%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

% Dielectric - dielectric boundary conditions - Horizontal charge-free
% boundary plane

clear all;
close all;

NORMAL = [0,0,1];

% Electric field vector
Ex1 = input('Enter x-component of E-field in medium 1, in V/m: ');
Ey1 = input('Enter y-component of E-field in medium 1, in V/m: ');
Ez1 = input('Enter z-component of E-field in medium 1, in V/m: ');
% Dielectrics
EPSR1 = input('Enter the relative permittivity of medium 1: ');
EPSR2 = input('Enter the relative permittivity of medium 2: ');

Emag = sqrt(Ex1^2 + Ey1^2 + Ez1^2);
E1 = [Ex1,Ey1,Ez1];

E1normal = Ez1.*NORMAL; 
E1tangential = E1 - E1normal;

E2normal = E1normal.*EPSR1/EPSR2; 
E2tangential = E1tangential;
E2 = E2normal + E2tangential;

disp('E-field in medium 2, in V/m, is:');
fprintf('(%.3f)*ux',E2(1)); 
fprintf(' + (%.3f)*uy',E2(2));
fprintf(' + (%.3f)*uz\n',E2(3));
 
A = [abs(E1(1)),abs(E1(2)),abs(E1(3)),abs(E2(1)),abs(E2(2)),abs(E2(3)),1];
B = max(A) + 0.1;

figure(1);
[x,y] = meshgrid(-B:B/4:B,-B:B/4:B);
Bz = NORMAL(1)*x + NORMAL(2)*y;
h = surf(x,y,Bz);axis equal; hold on;
colormap (white);
plot3(0,0,0,'ko','MarkerFaceColor','k'); hold on;
quiver3(0,0,0,NORMAL(1),NORMAL(2),NORMAL(3),0,'r','LineWidth',2); 
text (0,0,1/2,'n');
quiver3(0,0,0,E1(1),E1(2),E1(3),0,'b', 'LineWidth',2);
text (E1(1)/2,E1(2)/2,E1(3)/2,'E1');
quiver3(0,0,0,E2(1),E2(2),E2(3),0,'g','LineWidth',2);
text (E2(1)/2,E2(2)/2,E2(3)/2,'E2');
xlabel('x [m]'); ylabel('y [m]'); zlabel('z [m]');